/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.orbutil;

import com.sun.corba.se.internal.orbutil.Work;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public final class ThreadPool {
    private static int threadCounter = 0;
    private WorkQueue workToDo = new WorkQueue();
    private int availableWorkers = 0;
    private int inactivityTimeout;

    static /* synthetic */ int access$100() {
        return ThreadPool.getUniqueThreadId();
    }

    private static synchronized int getUniqueThreadId() {
        return threadCounter++;
    }

    public ThreadPool() {
        this.inactivityTimeout = 120000;
    }

    public ThreadPool(int n2) {
        this.inactivityTimeout = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Work requestWork() throws TimeoutException, InterruptedException {
        ++this.availableWorkers;
        try {
            if (this.workToDo.isEmpty()) {
                this.wait(this.inactivityTimeout);
                if (this.workToDo.isEmpty()) {
                    throw new TimeoutException();
                }
            }
        }
        finally {
            --this.availableWorkers;
        }
        return this.workToDo.dequeue();
    }

    public synchronized void addWork(Work work) {
        this.workToDo.enqueue(work);
        if (this.availableWorkers == 0) {
            PooledThread pooledThread = new PooledThread();
            try {
                pooledThread.setDaemon(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            pooledThread.start();
        } else {
            this.notify();
        }
    }

    private class PooledThread
    extends Thread {
        private Work currentWork;
        private int threadId = ThreadPool.access$100();

        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.setName("Idle");
                        this.currentWork = ThreadPool.this.requestWork();
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(this.currentWork.getName());
                        stringBuffer.append('[');
                        stringBuffer.append(this.threadId);
                        stringBuffer.append(']');
                        this.setName(stringBuffer.toString());
                        this.currentWork.process();
                    }
                }
                catch (TimeoutException timeoutException) {
                    return;
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }

        PooledThread() {
        }
    }

    private static class TimeoutException
    extends Exception {
        private TimeoutException() {
        }
    }

    private static final class WorkQueue {
        private LinkedList workToDo = new LinkedList();

        private WorkQueue() {
        }

        final boolean isEmpty() {
            return this.workToDo.isEmpty();
        }

        final Work dequeue() throws NoSuchElementException {
            return (Work)this.workToDo.removeFirst();
        }

        final void enqueue(Work work) {
            this.workToDo.add(work);
        }
    }
}

