/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.win32;

import org.eclipse.swt.internal.win32.OS;

public class TCHAR {
    int codePage;
    public char[] chars;
    public byte[] bytes;
    int byteCount;
    public static final int sizeof = OS.IsUnicode ? 2 : 1;

    public TCHAR(int n2, int n3) {
        this.codePage = n2;
        if (OS.IsUnicode) {
            this.chars = new char[n3];
        } else {
            this.byteCount = n3;
            this.bytes = new byte[this.byteCount];
        }
    }

    public TCHAR(int n2, char c2, boolean bl2) {
        char[] cArray;
        if (bl2) {
            char[] cArray2 = new char[2];
            cArray = cArray2;
            cArray2[0] = c2;
        } else {
            char[] cArray3 = new char[1];
            cArray = cArray3;
            cArray3[0] = c2;
        }
        this(n2, cArray, false);
    }

    public TCHAR(int n2, char[] cArray, boolean bl2) {
        this.codePage = n2;
        int n3 = cArray.length;
        if (OS.IsUnicode) {
            if (bl2 && (n3 == 0 || n3 > 0 && cArray[n3 - 1] != '\u0000')) {
                char[] cArray2 = new char[n3 + 1];
                System.arraycopy(cArray, 0, cArray2, 0, n3);
                cArray = cArray2;
            }
            this.chars = cArray;
        } else {
            int n4 = n2 != 0 ? n2 : 0;
            this.byteCount = n3 * 2 + (bl2 ? 1 : 0);
            this.bytes = new byte[this.byteCount];
            this.byteCount = OS.WideCharToMultiByte(n4, 0, cArray, n3, this.bytes, this.byteCount, null, null);
            if (bl2) {
                ++this.byteCount;
            }
        }
    }

    public TCHAR(int n2, String string, boolean bl2) {
        this(n2, TCHAR.getChars(string, bl2), false);
    }

    static char[] getChars(String string, boolean bl2) {
        int n2 = string.length();
        char[] cArray = new char[n2 + (bl2 ? 1 : 0)];
        string.getChars(0, n2, cArray, 0);
        return cArray;
    }

    public int length() {
        if (OS.IsUnicode) {
            return this.chars.length;
        }
        return this.byteCount;
    }

    public int strlen() {
        if (OS.IsUnicode) {
            int n2 = 0;
            while (n2 < this.chars.length) {
                if (this.chars[n2] == '\u0000') {
                    return n2;
                }
                ++n2;
            }
            return this.chars.length;
        }
        int n3 = 0;
        while (n3 < this.byteCount) {
            if (this.bytes[n3] == 0) {
                return n3;
            }
            ++n3;
        }
        return this.byteCount;
    }

    public int tcharAt(int n2) {
        if (OS.IsUnicode) {
            return this.chars[n2];
        }
        int n3 = this.bytes[n2] & 0xFF;
        if (OS.IsDBCSLeadByte((byte)n3)) {
            n3 = n3 << 8 | this.bytes[n2 + 1] & 0xFF;
        }
        return n3;
    }

    public String toString() {
        return this.toString(0, this.length());
    }

    public String toString(int n2, int n3) {
        if (OS.IsUnicode) {
            return new String(this.chars, n2, n3);
        }
        byte[] byArray = this.bytes;
        if (n2 != 0) {
            byArray = new byte[n3];
            System.arraycopy(this.bytes, n2, byArray, 0, n3);
        }
        char[] cArray = new char[n3];
        int n4 = this.codePage != 0 ? this.codePage : 0;
        int n5 = OS.MultiByteToWideChar(n4, 1, byArray, n3, cArray, n3);
        return new String(cArray, 0, n5);
    }
}

