/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.StyledTextEvent;
import org.eclipse.swt.custom.StyledTextListener;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.widgets.TypedListener;

class DefaultContent
implements StyledTextContent {
    private static final String LineDelimiter = System.getProperty("line.separator");
    Vector textListeners = new Vector();
    char[] textStore = new char[0];
    int gapStart = -1;
    int gapEnd = -1;
    int gapLine = -1;
    int highWatermark = 300;
    int lowWatermark = 50;
    int[][] lines = new int[50][2];
    int lineCount = 0;
    int expandExp = 1;
    int replaceExpandExp = 1;

    DefaultContent() {
        this.setText("");
    }

    void addLineIndex(int n2, int n3) {
        Object object;
        int n4 = this.lines.length;
        if (this.lineCount == n4) {
            object = new int[n4 + Compatibility.pow2(this.expandExp)][2];
            System.arraycopy(this.lines, 0, object, 0, n4);
            this.lines = object;
            ++this.expandExp;
        }
        object = new int[]{n2, n3};
        this.lines[this.lineCount] = (int[])object;
        ++this.lineCount;
    }

    int[][] addLineIndex(int n2, int n3, int[][] nArray, int n4) {
        int n5 = nArray.length;
        int[][] nArray2 = nArray;
        if (n4 == n5) {
            nArray2 = new int[n5 + Compatibility.pow2(this.replaceExpandExp)][2];
            ++this.replaceExpandExp;
            System.arraycopy(nArray, 0, nArray2, 0, n5);
        }
        int[] nArray3 = new int[]{n2, n3};
        nArray2[n4] = nArray3;
        return nArray2;
    }

    public void addTextChangeListener(TextChangeListener textChangeListener) {
        if (textChangeListener == null) {
            this.error(4);
        }
        StyledTextListener styledTextListener = new StyledTextListener(textChangeListener);
        this.textListeners.addElement(styledTextListener);
    }

    void adjustGap(int n2, int n3, int n4) {
        int n5;
        int n6;
        if (n2 == this.gapStart ? this.lowWatermark <= (n6 = this.gapEnd - this.gapStart - n3) && n6 <= this.highWatermark : n2 + n3 == this.gapStart && n3 < 0 && this.lowWatermark <= (n5 = this.gapEnd - this.gapStart - n3) && n5 <= this.highWatermark) {
            return;
        }
        this.moveAndResizeGap(n2, n3, n4);
    }

    void indexLines() {
        int n2 = 0;
        this.lineCount = 0;
        int n3 = this.textStore.length;
        int n4 = n2;
        while (n4 < n3) {
            char c2 = this.textStore[n4];
            if (c2 == '\r') {
                if (n4 + 1 < n3 && (c2 = this.textStore[n4 + 1]) == '\n') {
                    ++n4;
                }
                this.addLineIndex(n2, n4 - n2 + 1);
                n2 = n4 + 1;
            } else if (c2 == '\n') {
                this.addLineIndex(n2, n4 - n2 + 1);
                n2 = n4 + 1;
            }
            ++n4;
        }
        this.addLineIndex(n2, n4 - n2);
    }

    boolean isDelimiter(char c2) {
        if (c2 == '\r') {
            return true;
        }
        return c2 == '\n';
    }

    protected boolean isValidReplace(int n2, int n3, String string) {
        if (n3 == 0) {
            char c2;
            if (n2 == 0) {
                return true;
            }
            if (n2 == this.getCharCount()) {
                return true;
            }
            char c3 = this.getTextRange(n2 - 1, 1).charAt(0);
            if (c3 == '\r' && (c2 = this.getTextRange(n2, 1).charAt(0)) == '\n') {
                return false;
            }
        } else {
            char c4;
            char c5;
            char c6 = this.getTextRange(n2, 1).charAt(0);
            if (c6 == '\n' && n2 != 0 && (c5 = this.getTextRange(n2 - 1, 1).charAt(0)) == '\r') {
                return false;
            }
            c5 = this.getTextRange(n2 + n3 - 1, 1).charAt(0);
            if (c5 == '\r' && n2 + n3 != this.getCharCount() && (c4 = this.getTextRange(n2 + n3, 1).charAt(0)) == '\n') {
                return false;
            }
        }
        return true;
    }

    int[][] indexLines(int n2, int n3, int n4) {
        int[][] nArray = new int[n4][2];
        int n5 = 0;
        int n6 = 0;
        this.replaceExpandExp = 1;
        int n7 = n5;
        while (n7 < n3) {
            int n8 = n7 + n2;
            if (n8 < this.gapStart || n8 >= this.gapEnd) {
                char c2 = this.textStore[n8];
                if (c2 == '\r') {
                    if (n8 + 1 < this.textStore.length && (c2 = this.textStore[n8 + 1]) == '\n') {
                        ++n7;
                    }
                    nArray = this.addLineIndex(n5, n7 - n5 + 1, nArray, n6);
                    ++n6;
                    n5 = n7 + 1;
                } else if (c2 == '\n') {
                    nArray = this.addLineIndex(n5, n7 - n5 + 1, nArray, n6);
                    ++n6;
                    n5 = n7 + 1;
                }
            }
            ++n7;
        }
        int[][] nArray2 = new int[n6 + 1][2];
        System.arraycopy(nArray, 0, nArray2, 0, n6);
        int[] nArray3 = new int[]{n5, n7 - n5};
        nArray2[n6] = nArray3;
        return nArray2;
    }

    void insert(int n2, String string) {
        int n3;
        int[][] nArray;
        if (string.length() == 0) {
            return;
        }
        int n4 = this.getLineAtOffset(n2);
        int n5 = string.length();
        boolean bl2 = n2 == this.getCharCount();
        this.adjustGap(n2, n5, n4);
        int n6 = this.getOffsetAtLine(n4);
        int n7 = this.getPhysicalLine(n4).length();
        if (n5 > 0) {
            this.gapStart += n5;
            int n8 = 0;
            while (n8 < string.length()) {
                this.textStore[n2 + n8] = string.charAt(n8);
                ++n8;
            }
        }
        if ((nArray = this.indexLines(n6, n7, 10))[n3 = nArray.length - 1][1] == 0) {
            n3 = bl2 ? ++n3 : --n3;
        }
        this.expandLinesBy(n3);
        int n9 = this.lineCount - 1;
        while (n9 > n4) {
            this.lines[n9 + n3] = this.lines[n9];
            --n9;
        }
        n9 = 0;
        while (n9 < n3) {
            int[] nArray2 = nArray[n9];
            nArray2[0] = nArray2[0] + n6;
            this.lines[n4 + n9] = nArray[n9];
            ++n9;
        }
        if (n3 < nArray.length) {
            int[] nArray3 = nArray[n3];
            nArray3[0] = nArray3[0] + n6;
            this.lines[n4 + n3] = nArray[n3];
        }
        this.lineCount += n3;
        this.gapLine = this.getLineAtPhysicalOffset(this.gapStart);
    }

    void moveAndResizeGap(int n2, int n3, int n4) {
        int n5;
        int n6;
        char[] cArray = null;
        int n7 = this.gapEnd - this.gapStart;
        int n8 = n3 > 0 ? this.highWatermark + n3 : this.lowWatermark - n3;
        if (this.gapExists()) {
            this.lines[this.gapLine][1] = this.lines[this.gapLine][1] - n7;
            n6 = this.gapLine + 1;
            while (n6 < this.lineCount) {
                this.lines[n6][0] = this.lines[n6][0] - n7;
                ++n6;
            }
        }
        if (n8 < 0) {
            if (n7 > 0) {
                cArray = new char[this.textStore.length - n7];
                System.arraycopy(this.textStore, 0, cArray, 0, this.gapStart);
                System.arraycopy(this.textStore, this.gapEnd, cArray, this.gapStart, cArray.length - this.gapStart);
                this.textStore = cArray;
            }
            this.gapStart = this.gapEnd = n2;
            return;
        }
        cArray = new char[this.textStore.length + (n8 - n7)];
        n6 = n2;
        int n9 = n6 + n8;
        if (n7 == 0) {
            System.arraycopy(this.textStore, 0, cArray, 0, n6);
            System.arraycopy(this.textStore, n6, cArray, n9, cArray.length - n9);
        } else if (n6 < this.gapStart) {
            n5 = this.gapStart - n6;
            System.arraycopy(this.textStore, 0, cArray, 0, n6);
            System.arraycopy(this.textStore, n6, cArray, n9, n5);
            System.arraycopy(this.textStore, this.gapEnd, cArray, n9 + n5, this.textStore.length - this.gapEnd);
        } else {
            n5 = n6 - this.gapStart;
            System.arraycopy(this.textStore, 0, cArray, 0, this.gapStart);
            System.arraycopy(this.textStore, this.gapEnd, cArray, this.gapStart, n5);
            System.arraycopy(this.textStore, this.gapEnd + n5, cArray, n9, cArray.length - n9);
        }
        this.textStore = cArray;
        this.gapStart = n6;
        this.gapEnd = n9;
        if (this.gapExists()) {
            this.gapLine = n4;
            n5 = this.gapEnd - this.gapStart;
            this.lines[this.gapLine][1] = this.lines[this.gapLine][1] + n5;
            int n10 = this.gapLine + 1;
            while (n10 < this.lineCount) {
                this.lines[n10][0] = this.lines[n10][0] + n5;
                ++n10;
            }
        }
    }

    int lineCount(int n2, int n3) {
        if (n3 == 0) {
            return 0;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = n2;
        if (n6 >= this.gapStart) {
            n6 += this.gapEnd - this.gapStart;
        }
        while (n5 < n3) {
            if (n6 < this.gapStart || n6 >= this.gapEnd) {
                char c2 = this.textStore[n6];
                if (c2 == '\r') {
                    if (n6 + 1 < this.textStore.length && (c2 = this.textStore[n6 + 1]) == '\n') {
                        ++n6;
                        ++n5;
                    }
                    ++n4;
                } else if (c2 == '\n') {
                    ++n4;
                }
                ++n5;
            }
            ++n6;
        }
        return n4;
    }

    int lineCount(String string) {
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        while (n4 < n3) {
            char c2 = string.charAt(n4);
            if (c2 == '\r') {
                if (n4 + 1 < n3 && string.charAt(n4 + 1) == '\n') {
                    ++n4;
                }
                ++n2;
            } else if (c2 == '\n') {
                ++n2;
            }
            ++n4;
        }
        return n2;
    }

    public int getCharCount() {
        int n2 = this.gapEnd - this.gapStart;
        return this.textStore.length - n2;
    }

    public String getLine(int n2) {
        if (n2 >= this.lineCount || n2 < 0) {
            this.error(5);
        }
        int n3 = this.lines[n2][0];
        int n4 = this.lines[n2][1];
        int n5 = n3 + n4 - 1;
        if (!this.gapExists() || n5 < this.gapStart || n3 >= this.gapEnd) {
            while (n4 - 1 >= 0 && this.isDelimiter(this.textStore[n3 + n4 - 1])) {
                --n4;
            }
            return new String(this.textStore, n3, n4);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n6 = this.gapEnd - this.gapStart;
        stringBuffer.append(this.textStore, n3, this.gapStart - n3);
        stringBuffer.append(this.textStore, this.gapEnd, n4 - n6 - (this.gapStart - n3));
        n4 = stringBuffer.length();
        while (n4 - 1 >= 0 && this.isDelimiter(stringBuffer.charAt(n4 - 1))) {
            --n4;
        }
        return stringBuffer.toString().substring(0, n4);
    }

    public String getLineDelimiter() {
        return LineDelimiter;
    }

    String getFullLine(int n2) {
        int n3 = this.lines[n2][0];
        int n4 = this.lines[n2][1];
        int n5 = n3 + n4 - 1;
        if (!this.gapExists() || n5 < this.gapStart || n3 >= this.gapEnd) {
            return new String(this.textStore, n3, n4);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n6 = this.gapEnd - this.gapStart;
        stringBuffer.append(this.textStore, n3, this.gapStart - n3);
        stringBuffer.append(this.textStore, this.gapEnd, n4 - n6 - (this.gapStart - n3));
        return stringBuffer.toString();
    }

    String getPhysicalLine(int n2) {
        int n3 = this.lines[n2][0];
        int n4 = this.lines[n2][1];
        return this.getPhysicalText(n3, n4);
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public int getLineAtOffset(int n2) {
        int n3;
        if (n2 > this.getCharCount() || n2 < 0) {
            this.error(5);
        }
        int n4 = n2 < this.gapStart ? n2 : n2 + (this.gapEnd - this.gapStart);
        if (this.lineCount > 0 && n4 == this.lines[n3 = this.lineCount - 1][0] + this.lines[n3][1]) {
            return n3;
        }
        n3 = this.lineCount;
        int n5 = -1;
        int n6 = this.lineCount;
        while (n3 - n5 > 1) {
            n6 = (n3 + n5) / 2;
            int n7 = this.lines[n6][0];
            int n8 = n7 + this.lines[n6][1] - 1;
            if (n4 <= n7) {
                n3 = n6;
                continue;
            }
            if (n4 <= n8) {
                n3 = n6;
                break;
            }
            n5 = n6;
        }
        return n3;
    }

    int getLineAtPhysicalOffset(int n2) {
        int n3 = this.lineCount;
        int n4 = -1;
        int n5 = this.lineCount;
        while (n3 - n4 > 1) {
            n5 = (n3 + n4) / 2;
            int n6 = this.lines[n5][0];
            int n7 = n6 + this.lines[n5][1] - 1;
            if (n2 <= n6) {
                n3 = n5;
                continue;
            }
            if (n2 <= n7) {
                n3 = n5;
                break;
            }
            n4 = n5;
        }
        return n3;
    }

    public int getOffsetAtLine(int n2) {
        int n3;
        if (n2 == 0) {
            return 0;
        }
        if (n2 >= this.lineCount || n2 < 0) {
            this.error(5);
        }
        if ((n3 = this.lines[n2][0]) > this.gapEnd) {
            return n3 - (this.gapEnd - this.gapStart);
        }
        return n3;
    }

    void expandLinesBy(int n2) {
        int n3 = this.lines.length;
        if (n3 - this.lineCount >= n2) {
            return;
        }
        int[][] nArray = new int[n3 + Math.max(10, n2)][2];
        System.arraycopy(this.lines, 0, nArray, 0, n3);
        this.lines = nArray;
    }

    void error(int n2) {
        SWT.error(n2);
    }

    boolean gapExists() {
        return this.gapStart != this.gapEnd;
    }

    String getPhysicalText(int n2, int n3) {
        return new String(this.textStore, n2, n3);
    }

    public String getTextRange(int n2, int n3) {
        if (this.textStore == null) {
            return "";
        }
        if (n3 == 0) {
            return "";
        }
        int n4 = n2 + n3;
        if (!this.gapExists() || n4 < this.gapStart) {
            return new String(this.textStore, n2, n3);
        }
        if (this.gapStart < n2) {
            int n5 = this.gapEnd - this.gapStart;
            return new String(this.textStore, n2 + n5, n3);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.textStore, n2, this.gapStart - n2);
        stringBuffer.append(this.textStore, this.gapEnd, n4 - this.gapStart);
        return stringBuffer.toString();
    }

    public void removeTextChangeListener(TextChangeListener textChangeListener) {
        if (textChangeListener == null) {
            this.error(4);
        }
        int n2 = 0;
        while (n2 < this.textListeners.size()) {
            TypedListener typedListener = (TypedListener)this.textListeners.elementAt(n2);
            if (typedListener.getEventListener() == textChangeListener) {
                this.textListeners.removeElementAt(n2);
                break;
            }
            ++n2;
        }
    }

    public void replaceTextRange(int n2, int n3, String string) {
        if (!this.isValidReplace(n2, n3, string)) {
            SWT.error(5);
        }
        StyledTextEvent styledTextEvent = new StyledTextEvent(this);
        styledTextEvent.type = 3003;
        styledTextEvent.start = n2;
        styledTextEvent.replaceLineCount = this.lineCount(n2, n3);
        styledTextEvent.text = string;
        styledTextEvent.newLineCount = this.lineCount(string);
        styledTextEvent.replaceCharCount = n3;
        styledTextEvent.newCharCount = string.length();
        this.sendTextEvent(styledTextEvent);
        this.delete(n2, n3, styledTextEvent.replaceLineCount + 1);
        this.insert(n2, string);
        styledTextEvent = new StyledTextEvent(this);
        styledTextEvent.type = 3006;
        this.sendTextEvent(styledTextEvent);
    }

    void sendTextEvent(StyledTextEvent styledTextEvent) {
        int n2 = 0;
        while (n2 < this.textListeners.size()) {
            ((StyledTextListener)this.textListeners.elementAt(n2)).handleEvent(styledTextEvent);
            ++n2;
        }
    }

    public void setText(String string) {
        this.textStore = string.toCharArray();
        this.gapStart = -1;
        this.gapEnd = -1;
        this.expandExp = 1;
        this.indexLines();
        StyledTextEvent styledTextEvent = new StyledTextEvent(this);
        styledTextEvent.type = 3004;
        styledTextEvent.text = "";
        this.sendTextEvent(styledTextEvent);
    }

    void delete(int n2, int n3, int n4) {
        int n5;
        if (n3 == 0) {
            return;
        }
        int n6 = this.getLineAtOffset(n2);
        int n7 = this.getOffsetAtLine(n6);
        int n8 = this.getLineAtOffset(n2 + n3);
        String string = "";
        boolean bl2 = false;
        if (n2 + n3 < this.getCharCount() && (string = this.getTextRange(n2 + n3 - 1, 2)).charAt(0) == '\r' && string.charAt(1) == '\n') {
            bl2 = true;
        }
        this.adjustGap(n2 + n3, -n3, n6);
        int[][] nArray = this.indexLines(n2, n3 + (this.gapEnd - this.gapStart), n4);
        if (n2 + n3 == this.gapStart) {
            this.gapStart -= n3;
        } else {
            this.gapEnd += n3;
        }
        int n9 = n2;
        boolean bl3 = false;
        while (n9 < this.textStore.length && !bl3) {
            if ((n9 < this.gapStart || n9 >= this.gapEnd) && this.isDelimiter((char)(n5 = this.textStore[n9]))) {
                if (n9 + 1 < this.textStore.length && n5 == 13 && this.textStore[n9 + 1] == '\n') {
                    ++n9;
                }
                bl3 = true;
            }
            ++n9;
        }
        this.lines[n6][1] = n2 - n7 + (n9 - n2);
        n5 = nArray.length - 1;
        if (bl2) {
            --n5;
        }
        int n10 = n8 + 1;
        while (n10 < this.lineCount) {
            this.lines[n10 - n5] = this.lines[n10];
            ++n10;
        }
        this.lineCount -= n5;
        this.gapLine = this.getLineAtPhysicalOffset(this.gapStart);
    }
}

