/*
 * Decompiled with CFR 0.152.
 */
package com.mascotcapsule.micro3d.v3;

import com.mascotcapsule.micro3d.v3.Util3D;

public class Vector3D {
    public int x;
    public int y;
    public int z;

    public Vector3D() {
    }

    public Vector3D(Vector3D vector3D) {
        this.set(vector3D);
    }

    public Vector3D(int n2, int n3, int n4) {
        this.x = n2;
        this.y = n3;
        this.z = n4;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final int getZ() {
        return this.z;
    }

    public final void setX(int n2) {
        this.x = n2;
    }

    public final void setY(int n2) {
        this.y = n2;
    }

    public final void setZ(int n2) {
        this.z = n2;
    }

    public final void set(Vector3D vector3D) {
        if (vector3D == null) {
            throw Util3D.a;
        }
        this.x = vector3D.x;
        this.y = vector3D.y;
        this.z = vector3D.z;
    }

    public final void set(int n2, int n3, int n4) {
        this.x = n2;
        this.y = n3;
        this.z = n4;
    }

    public final void unit() {
        int n2 = this.x * this.x + this.y * this.y + this.z * this.z;
        int n3 = Util3D.sqrt(n2);
        if (n3 == 0) {
            n3 = 1;
        }
        this.x = (this.x << 12) / n3;
        this.y = (this.y << 12) / n3;
        this.z = (this.z << 12) / n3;
    }

    public final int innerProduct(Vector3D vector3D) {
        if (vector3D == null) {
            throw Util3D.a;
        }
        return this.x * vector3D.x + this.y * vector3D.y + this.z * vector3D.z;
    }

    public final void outerProduct(Vector3D vector3D) {
        if (vector3D == null) {
            throw Util3D.a;
        }
        Vector3D vector3D2 = new Vector3D();
        new Vector3D().x = this.y * vector3D.z - this.z * vector3D.y >> 12;
        vector3D2.y = this.z * vector3D.x - this.x * vector3D.z >> 12;
        vector3D2.z = this.x * vector3D.y - this.y * vector3D.x >> 12;
        vector3D.set(vector3D2);
    }

    public static final int innerProduct(Vector3D vector3D, Vector3D vector3D2) {
        if (vector3D == null || vector3D2 == null) {
            throw Util3D.a;
        }
        return vector3D.x * vector3D2.x + vector3D.y * vector3D2.y + vector3D.z * vector3D2.z;
    }

    public static final Vector3D outerProduct(Vector3D vector3D, Vector3D vector3D2) {
        if (vector3D == null || vector3D2 == null) {
            throw Util3D.a;
        }
        Vector3D vector3D3 = new Vector3D();
        new Vector3D().x = vector3D.y * vector3D2.z - vector3D.z * vector3D2.y >> 12;
        vector3D3.y = vector3D.z * vector3D2.x - vector3D.x * vector3D2.z >> 12;
        vector3D3.z = vector3D.x * vector3D2.y - vector3D.y * vector3D2.x >> 12;
        return vector3D3;
    }
}

